*********************************************
*** This do-file creates tables 11 and 12 ***
*********************************************

clear
clear matrix
set matsize 4000
set mem 1100m

*** !!! PLEASE SPECIFY !!! the directory where the file nj_respondents_new.dta is stored:
local njdir=""

use `njdir'nj_respondents_new.dta, clear

*** create dummies of duration for each cohort
gen ud = round(udur_wkpd_wrkacc)
forvalues x=1(1)8 {
quietly tab ud if coh==`x', gen(ud_coh`x'_dummy_)
}

*** drop from sample for fixed effect estimates those who said that they didnt search because they accepted a job
*** or those whose benefits ended
forvalues x = 1(1)26 {
sort id week
by id: replace q9b=1 if q9b[`x'-1]==1 & week==`x' & id[`x']==id[`x'-1]
}
replace insample_wrkacc=0 if q9b==1
replace insample_wrkacc=0 if end2cui1==1 & date_new_claim==.


*** number of job offers ***

* number of job offers each week
gen     njoboff = 0
replace njoboff = q12_1_b           if q12_1_a==1 & q12_1_b!=.
replace njoboff = 1                 if q12_1_a==1 & q12_1_b==.
replace njoboff = njoboff + q12_2_b if q12_2_a==1 & q12_2_b!=.
replace njoboff = njoboff + 1       if q12_2_a==1 & q12_2_b==.

* number of job offers over entire survey period and number of weeks with job offer over entire survey period
gen njoboff_tot   = 0  if week==1
gen njoboff_totwk = 0  if week==1
forvalues x=1(1)26 {
sort id week
quietly by id: replace njoboff_tot   = njoboff_tot + njoboff[`x']   if week==1 & joboff7dint[`x']==1
quietly by id: replace njoboff_totwk = njoboff_totwk + 1 if week==1 & joboff7dint[`x']==1
}


*** indicator for whether received (full-time / part-time / any) job offer during 12 weeks of baseline study period
*** (for those with 2 or more interviews)

local basx=2
gen ijoboff_ft=0 if week==1 & nweeks_bas>=`basx' & extended_study==0
gen ijoboff=0 if week==1 & nweeks_bas>=`basx' & extended_study==0
gen ijoboff_pt=0 if week==1 & nweeks_bas>=`basx' & extended_study==0

forvalues x=1(1)12 {
sort id week
quietly by id: replace ijoboff_ft = 1 if week==1 & joboff7d_ft[`x']==1 & nweeks_bas>=`basx' & extended_study[`x']==0
quietly by id: replace ijoboff_ft = 1 if week==1 & joboffint_ft[`x']==1 & nweeks_bas>=`basx' & extended_study[`x']==0
quietly by id: replace ijoboff_pt = 1 if week==1 & joboff7d_pt[`x']==1 & nweeks_bas>=`basx' & extended_study[`x']==0
quietly by id: replace ijoboff_pt = 1 if week==1 & joboffint_pt[`x']==1 & nweeks_bas>=`basx' & extended_study[`x']==0
quietly by id: replace ijoboff = 1 if week==1 & joboff7d[`x']==1 & nweeks_bas>=`basx' & extended_study[`x']==0
quietly by id: replace ijoboff = 1 if week==1 & joboffint[`x']==1 & nweeks_bas>=`basx' & extended_study[`x']==0
}

*** define early UI exit before march 14, 2010

gen     iuiexit1 = 0
replace iuiexit1 = 1 if week==1 &  lpdate < 18336 & weekspaid_all_end< potdur_extnew & date_new_claim==. & weekspaid_all_end!=51 & weekspaid_all_end!=52

* early exit before jan 12, 2010
gen     iuiexit0 = 0
replace iuiexit0 = 1  if week==1 &  lpdate < 18274 & weekspaid_all_end< potdur_extnew & date_new_claim==. & weekspaid_all_end!=51 & weekspaid_all_end!=52


*** drop extended study
drop if extended_study==1


*** fixed effect regressions by cohort ***

* define predicted variables (job search, reservation wage ratio, reservation wage and job search methods)
gen tw_jobsearch_pred = .
gen tu_jobsearch_pred = .
gen lrwr_pred = .
gen lreswage_hrly_pred = .
gen lreswage_wkly_pred = .
forvalues y=1(1)12 {
gen q10a_`y'_pred = .
}


* define alternative to predicted values (first observation)
gen tw_jobsearch_fpred = tw_jobsearch if insample_wrkacc==1
gen tu_jobsearch_fpred = tu_jobsearch if insample_wrkacc==1
gen lrwr_fpred         = lrwr if insample_wrkacc==1
gen lreswage_hrly_fpred= lreswage_hrly if insample_wrkacc==1
gen lreswage_wkly_fpred= lreswage_wkly if insample_wrkacc==1
forvalues y=1(1)12 {
gen q10a_`y'_fpred = .
}

* estimate fixed effects models and extract fixed effects
tab q2, gen(q2_)
forvalues x=1(1)8 {
quietly areg tw_jobsearch ud_coh`x'_dummy_* [pw=curwkwgt] if coh==`x' & insample_wrkacc==1, absorb(caseid)
predict tw_jobsearch_pred`x', d
replace tw_jobsearch_pred = tw_jobsearch_pred`x' if coh==`x' & insample_wrkacc==1,
drop    tw_jobsearch_pred`x'

quietly areg lrwr ud_coh`x'_dummy_* [pw=curwkwgt] if coh==`x' & insample_wrkacc==1, absorb(caseid)
predict lrwr_pred`x', d
replace lrwr_pred = lrwr_pred`x' if coh==`x' & insample_wrkacc==1,
drop    lrwr_pred`x'
}

* bring forward estimate individual fixed effect to first week (if not already filled in)
forvalues x = 1(1)26 {
sort id week
by id: replace tw_jobsearch_pred = tw_jobsearch_pred[`x'] if tw_jobsearch_pred[`x']!=. &tw_jobsearch_pred[1]==. & week==1
by id: replace tw_jobsearch_fpred = tw_jobsearch_fpred[`x'] if tw_jobsearch_fpred[`x']!=. &tw_jobsearch_fpred[1]==. & week==1

by id: replace lrwr_pred  = lrwr_pred[`x']  if lrwr_pred[`x']!=.  &lrwr_pred[1]==.  & week==1
by id: replace lrwr_fpred = lrwr_fpred[`x'] if lrwr_fpred[`x']!=. &lrwr_fpred[1]==. & week==1
}

drop ud_coh*


*** keep first week for each participant
drop if week>1


*** redefine received job offer for iteration below over regression models
gen     iuiexit2 = ijoboff
gen     iuiexit3 = ijoboff_ft





*** Table 10: tabulation of job offers by part-time status  ***

* e12=4 means not looking in last 4 weeks
replace e12 = 4 if e10==2

* job offer or early ui exit
gen iuiexit_nojoboff = 0 if week==1 & nweeks_bas>=2 & extended_study==0
replace iuiexit_nojoboff = 1 if week==1 & ijoboff==0 & iuiexit0==1 & nweeks_bas>=2 & extended_study==0

* tabs
tab e12 ijoboff_ft [aw=perswgt] if q9b!=1, row
tab e12 ijoboff_pt [aw=perswgt] if q9b!=1, row
tab e12 ijoboff [aw=perswgt] if q9b!=1, row
tab e12 iuiexit_nojoboff [aw=perswgt] if q9b!=1, row




*** Table 11: regressions ***
drop r_white ethnic_nhisp educsvy_1
forvalues x=1(1)2 {

if `x'>=2 & `x'<=3 {
* exit on total amount spent on job search without controls
eststo tab11_totons1_dep`x': dprobit iuiexit`x' tw_jobsearch_pred [pw=perswgt]
estadd ysumm, mean min max

* exit on total amount spent on job search with controls
eststo tab11_totons2_dep`x': dprobit iuiexit`x' tw_jobsearch_pred ///
 coh_2-coh_8 [pw=perswgt]
estadd ysumm, mean min max

* exit on total amount spent on job search with controls
eststo tab11_totons3_dep`x': dprobit iuiexit`x' tw_jobsearch_pred ///
 coh_2-coh_8 recallexp_entry withrecalldate_entry ///
age agesq educsvy_* r_* ethnic_* female married [pw=perswgt]
estadd ysumm, mean min max
}

* exit on total amount spent on job search without controls
eststo tab11_totnc_dep`x': dprobit iuiexit`x' tw_jobsearch_pred lrwr_pred [pw=perswgt]
estadd ysumm, mean min max

* exit on total amount spent on job search with controls
eststo tab11_totcoh_dep`x': dprobit iuiexit`x' tw_jobsearch_pred lrwr_pred ///
 coh_2-coh_8 [pw=perswgt]
estadd ysumm, mean min max

* exit on total amount spent on job search with controls
eststo tab11_tot_dep`x': dprobit iuiexit`x' tw_jobsearch_pred lrwr_pred ///
 coh_2-coh_8 recallexp_entry withrecalldate_entry ///
age agesq educsvy_* r_* ethnic_* female married [pw=perswgt]
estadd ysumm, mean min max

}

estout tab11* using  `njdir'brookings_table11.txt, ///
cells(b(fmt(4)) se(par star fmt(4))) starlevels(* 0.1 ** 0.05 *** 0.01) legend margin stats(ymean ymin ymax N r2_p) replace

eststo clear
stop



